#include "adc.h"

#include <avr/io.h>

/*!
 *	@brief
 *		Wczenie ukadu ADC
 *	@details
 *		Inicjalizacja polega na ustawieniu preskalera, napicia referencyjnego
 *		oraz wczeniu jednostki ADC.
 */
void adcEnable(void)
{
	ADMUX = (1<<REFS0);
	ADCSRA = (1<<ADEN);
	adcConvert();			//dummy conversation
}

/*!
 *	@brief
 *		Wyczenie
 */
void adcDisable(void)
{
	ADCSRA = 0;
}

/*!
 *	@brief
 *		wybranie kanalu do pomiaru napiecia
 *	@param source
 *		Wskazanie na kanal, na ktorym nalezy dokonac pomiaru
 */
void adcSetChannel(_adcSource source)
{
	uint8_t sourceConfig = 0;
	if(source == ADC_CHANNEL_0)
		sourceConfig = 0;
	else if(source == ADC_CHANNEL_1)
		sourceConfig = 1;
	else if(source == ADC_CHANNEL_2)
		sourceConfig = 2;
	else if(source == ADC_CHANNEL_3)
		sourceConfig = 3;
	else if(source == ADC_CHANNEL_4)
		sourceConfig = 4;
	else if(source == ADC_CHANNEL_5)
		sourceConfig = 5;
	else if(source == ADC_CHANNEL_6)
		sourceConfig = 6;
	else if(source == ADC_CHANNEL_7)
		sourceConfig = 7;
	else if(source == ADC_CHANNEL_1_1V)
		sourceConfig = 0x1E;
	else if(source == ADC_CHANNEL_0V)
		sourceConfig = 0x1F;
	
	ADMUX &= ~(ADC_CHANNEL_MASK);
	ADMUX |= sourceConfig;
}	

/*!
 *	@brief
 *		Procedura dokonuje pomiaru napiecia
 *	@details
 *		Procedura wykonywana synchronicznie (czeka na zakonczenie konwersji)
 *	@return
 *		Wynik pomiaru (dokadno 10-bitowa)
 */
uint16_t adcConvert(void)
{
	uint16_t result;
	ADCSRA |= (1<<ADSC);
	while((ADCSRA & (1<<ADSC)) != 0)
		/*trwa pomiar*/;
	result = ADC;
	return result;
}	