/*!
 *  @file crc.h
 *	@brief Zestaw funkcji do obliczania sum kontrolnych CRC
 */ 


#ifndef CRC_H_
#define CRC_H_

#include <stdint.h>
#include <avr/pgmspace.h>

#define CRC_MODBUS_INIT_VALUE	0xFFFF

/*!
	@brief Obliczanie sumy CRC dla protokołu Modbus
	@params uart Struktura zawierająca bufor nadawczy oraz odbiorczy,
		z jednego z nich (wskazane przez drugi parametr) obliczana jest suma CRC
	@params transmittDataLength ilość wysyłanych bajtów; gdy transmittDataLength==0 oznacza że 
		suma crc ma być obliczona z bufora odbiorczego
*/
void crc16ModbusNext(uint8_t byte, uint16_t * crc);

void crc16ModbusCompute(uint16_t * crcPnt, uint8_t *data, uint16_t length);

#endif /* CRC_H_ */
