﻿/*
 * flash.c
 *
 * Created: 2012-06-10 20:46:47
 *  Author: marek
 */ 

#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/boot.h>

#include "crc.h"
#include "processor.h"
#include "flash.h"

uint8_t pageTempData[SPM_PAGESIZE];		/*!< Dane do zapisania na stronie*/
uint8_t pageTempDataUsed;				/*!< flaga mowiaca o tym czy w tabilcy pageTempData znajduja sie wazne dane */
uint32_t pageBeginAddress;				/*!< adres poczatku strony */

void flashActualizationBegin(void)
{
	//wykasowanie strony flash zawierajacej sume CRC programu
	rwwEnable();
	boot_page_erase(BOOT_SECTION_START - SPM_PAGESIZE);
}

void flashSavePage(uint32_t flashByteAddress, uint8_t * bytePnt)
{
	uint16_t * wordPnt = (uint16_t *)bytePnt;
	uint8_t sreg = SREG;
	cli();
	boot_page_erase_safe (flashByteAddress);
	for (uint16_t i=0; i<SPM_PAGESIZE; i+=2)
	{
		uint16_t w = *wordPnt++;
		boot_page_fill_safe (i, w);
	}
	boot_page_write_safe (flashByteAddress);
	SREG = sreg;
}

EFlashWriteResult flashSaveFromModbus (uint32_t byteAddress, uint8_t *buf)
{
	uint8_t pageBeginPartInitFlag;
	// sprawdzenie czy dane dotycza pierwszej czesci strony:
	if((byteAddress % SPM_PAGESIZE )==0)
	{
	 	memmove(pageTempData, buf, SPM_PAGESIZE/2);
		pageTempDataUsed = 1;
		pageBeginAddress = byteAddress;
	 	return EFlashWriteResult_AddToBuffer;
	}
	
	pageBeginPartInitFlag = (pageTempDataUsed && (byteAddress == pageBeginAddress + SPM_PAGESIZE/2));
	// sprawdzenie czy dane dotycza drugiej czesci strony i czy byla podana pierwsza czesc strony:
	if(pageBeginPartInitFlag)
	{
		memmove(pageTempData + SPM_PAGESIZE/2, buf, SPM_PAGESIZE/2);
		flashSavePage(pageBeginAddress, pageTempData);
		pageTempDataUsed = 0;
		return EFlashWriteResult_SaveToFlash;
	}
	else
	{
		return EFlashWriteResult_Error;
	}		
}

EFlashWriteResult flashActualizationFinished(void)
{
	if(pageTempDataUsed)
	{
		memset(pageTempData + SPM_PAGESIZE/2, 0xFF, SPM_PAGESIZE/2);
		flashSavePage(pageBeginAddress, pageTempData);
		pageTempDataUsed = 0;
		
		return EFlashFinishResult_SaveToFlash;
	}
	return EFlashFinishResult_SaveUnnecessary;
}


void flashSaveAllProgCrc (void)
{
	uint16_t flashCrc = CRC_MODBUS_INIT_VALUE;
	uint8_t flashData;
	uint16_t pageIndex = 0;
	for (uint32_t i = 0; i < BOOT_SECTION_START-2;i++)
	{
		flashData = pgm_read_byte_far(i);
		crc16ModbusNext(flashData, &flashCrc);
		if(i >= BOOT_SECTION_START - SPM_PAGESIZE)
		{
			pageTempData[pageIndex++] = flashData;
		}
	}
	pageTempData[SPM_PAGESIZE-2] = (uint8_t)(flashCrc & 0xFF);
	pageTempData[SPM_PAGESIZE-1] = (uint8_t)((flashCrc >> 8) & 0xFF);
	flashSavePage(BOOT_SECTION_START - SPM_PAGESIZE, pageTempData);
	boot_rww_enable_safe();// Reenable RWW-section again. We need this if we want to jump back to the application after bootloading.
}

void flashComputePageCrc(uint16_t *crcPnt, uint32_t byteAddress, uint16_t byteCount)
{
	uint16_t i;
	uint8_t flashData;
	for (i = 0; i < byteCount; i++)
	{
		flashData = pgm_read_byte_far(byteAddress);
		crc16ModbusNext(flashData, crcPnt);
		byteAddress++;
	}
}

void rwwEnable(void)
{
	boot_rww_enable_safe();// Reenable RWW-section again. We need this if we want to jump back to the application after bootloading.	
}
