﻿/*
 * flash.h
 *
 * Created: 2012-06-10 20:47:01
 *  Author: marek
 */ 
#ifndef FLASH_H_
#define FLASH_H_

typedef enum
{
	EFlashWriteResult_Error,
	EFlashWriteResult_AddToBuffer,		/* dane zapisane w buforze */
	EFlashWriteResult_SaveToFlash,		/* dane zapisane w pamieci flash */
}EFlashWriteResult;

typedef enum
{
	EFlashFinishResult_SaveUnnecessary,		/* danych nie bylo trzeba zapisywac we flashu */
	EFlashFinishResult_SaveToFlash,			/* dane zapisane w pamieci flash */
}EFlashFinishResult;

/*!
	@brief Wykasowanie calego obszaru pamieci flash przeznaczonego na aplikacje
*/
void flashActualizationBegin(void);


/*!
	@brief Funkcja zapisuje dane w pamięci FLASH
	@details Należy zadbać, żeby wywoływać funkcję podając jako adres pamięci flash adres początku kolejnej strony
	@param flashByteAddress Adres pamięci flash, gdzie należy zapisać dane
	@param bytePnt Wskaźnik na adres w pamięci SRAM gdzie znajdują się dane jakie należy zapisać w pamięci FLASH
*/
void flashSavePage(uint32_t flashByteAddress, uint8_t * bytePnt);


/*!
	@brief Klasa pośrednicząca przy zapisie do pamięci flash danych pobieranych protokołem modbus
	@details Poprzez protokół modbus otrzymywane są zestawy 128 B danych; dwa zestawy danych (256B) składa się na jedną stronę pamięci flash
	@param byteAddress Adres danych przekazywanych do zapisania w pamięci flash
	@param buf wskaznik na dane
	@return 1-ok; 0-błąd (zly adres danych)
*/
EFlashWriteResult flashSaveFromModbus (uint32_t byteAddress, uint8_t *buf);

/*
	@brief Zakonczenie aktualizacji pamieci flash
	@details Funkcja sprawdza czy zapis ostatniego czesci programu zostal faktycznie zapisane w pamieci flash i 
		ewentualnie dokonuje zapisu
*/
EFlashWriteResult flashActualizationFinished(void);

/*!
	@brief Funkcja aktualizuje (zapisuje do flasha) sumę kontrolną CRC z pamięci FLASH przeznaczonej na zwykły program
	@return 1-zapis powiódł się; 0-zapis nie udany
*/
void flashSaveAllProgCrc(void);

/*!
	@brief Przeliczenie sumy kontrolnej z danych zapisanych w pamieci flash
	@param crcPnt Wskaznik na dotychczas obliczona sume kontrolna CRC
	@param byteAddres Adres w pamieci flash (adres bajtu) od ktorego zaczac obliczanie sumy CRC
	@param byteCount Ilosc bajtow dla ktorych przeliczyc sume CRC
*/
void flashComputePageCrc(uint16_t *crcPnt, uint32_t byteAddress, uint16_t byteCount);

/*!
	@brief Aktywuje sekcje RWW po wgrywaniu w niej nowego programu
*/
void rwwEnable(void);
#endif /* FLASH_H_ */