#include <avr/io.h>
#include <avr/interrupt.h>
#include "interrupts.h"
#include "uart.h"
#include "timers.h"

ISR(TIMER0_COMPA_vect)
{
	TCCR0B = 0;				//timer stop
	UCSR0B |= (1<<TXCIE0) | (1<<UDRIE0);
}

ISR(TIMER2_COMPA_vect)
{
	timeMsFlag = 1;
}

//uart0:
ISR(USART0_RX_vect)
{
	uart0RxVectImpl();
}
ISR(USART0_UDRE_vect)
{
	uart0UdreVectImpl();
}
ISR(USART0_TX_vect)
{
	uart0TxVectImpl();
}
