/*
 * led.c
 *
 * Created: 2012-03-02 00:01:28
 *  Author: marek
 */ 

#include <stdint.h>
#include <avr/io.h>

#include "led.h"
#include "processor.h"
#include "timers.h"
#include "main.h"


/*!
	@brief Obsuga mrugania diody w zaleznosci od trybu w jakim sie znajduje urzadzenie (aktualizacja/brak aktualizacji)
*/
void ledService(void)
{
	static uint8_t workSubstate = 0;
	uint8_t timeValue = 50/TIMEOUT_UNIT;
	
	
	
	// okreslanie czestotliwosci mrugania diody (w zaleznosci od trybu):
	if(getWorkState() == MODE_ACT || getWorkState() == MODE_ACT_END)
	{
		timeValue = 1000/TIMEOUT_UNIT;
		// Sprawdz, czy nie wygasl czas maksymalnego trwania trybu:
		if(!getTimer1Sec(TMR_1SEC_ACTUALIZATION_ERROR))
		{
			setWorkState(MODE_ACT_ERR);
		}
	}		
	else
	{
		timeValue = 50/TIMEOUT_UNIT;
	}		
	
	//obsluga diody:
	switch(workSubstate)
	{
		case 0:
			if(!getTimerShort(TMR_SHORT_LED))
			{
				//wlaczenie diody:
				LED_ON();
				setTimerShort(TMR_SHORT_LED, timeValue);
				workSubstate = 1;				
			}
			break;
		default:
		case 1:
			if(!getTimerShort(TMR_SHORT_LED))
			{
				//wylaczenie diody:
				LED_OFF();
				setTimerShort(TMR_SHORT_LED, timeValue);
				workSubstate = 0;
			}
			break;			
	}
}
