/*!
 *  @file processor.h
 *	@brief Definicje stałych i makr związanych z ustawieniami sprzętowymi
 */ 

#ifndef PROCESSOR_H_
#define PROCESSOR_H_

#include "uart.h"

#define BOOT_SECTION_START	0x1E000

//uart baud rates:
#if F_CPU == 18432000
	#define BAUDRATE_1200_UBRR		0x03BF
	#define BAUDRATE_2400_UBRR		0x01DF
	#define BAUDRATE_4800_UBRR		0x00EF
	#define BAUDRATE_9600_UBRR		0x0077
	#define BAUDRATE_19200_UBRR		0x003B
	#define BAUDRATE_38400_UBRR		0x001D
	#define BAUDRATE_57600_UBRR		0x0013
	#define BAUDRATE_115200_UBRR	0x0009
#elif F_CPU == 11059200
	#define BAUDRATE_1200_UBRR		0x023F
	#define BAUDRATE_2400_UBRR		0x011F
	#define BAUDRATE_4800_UBRR		0x008F
	#define BAUDRATE_9600_UBRR		0x0047
	#define BAUDRATE_19200_UBRR		0x0023
	#define BAUDRATE_38400_UBRR		0x0011
	#define BAUDRATE_57600_UBRR		0x000B
	#define BAUDRATE_115200_UBRR	0x0005
#endif // F_CPU == 18432000 | 11059200
#define BAUDRATE_NONE_UBRR		0xFFFF

//uart0:
#define UART0_TXD_DIR_REG	DDRD
#define UART0_TXD_PORT_REG	PORTD
#define UART0_TXD_LINE		PD1
#define UART0_RXD_DIR_REG	DDRD
#define UART0_RXD_PORT_REG	PORTD
#define UART0_RXD_LINE		PD0
#define UART0_RE_DIR_REG	DDRD
#define UART0_RE_PORT_REG	PORTD
#define UART0_RE_LINE		PD5
#define UART0_DE_DIR_REG	DDRD
#define UART0_DE_PORT_REG	PORTD
#define UART0_DE_LINE		PD4
//LED:
#define	LED_OUT_REG			PORTB	//rejestr wyjsciowy portu dla diody led
#define	LED_DIR_REG			DDRB	//rejestr kierunku portu dla diody led
#define	LED_LINE			6		//nr linii diody led
//dipswitch:
#define DIP_L_DIR_REG	DDRA
#define DIP_L_LINE		DDA0
#define DIP_H_DIR_REG	DDRA
#define DIP_H_LINE		DDA1


/*!
	@brief
		Opoznienie wysylania danych po interfejsie uart0
	@param baudRate
		Predkosc komunikacji, dla ktorej nalezy dac opoznienie
	@details
		Opoznienie wynosi min. 3.5 znaku wysylanego podana predkoscia
*/
void delayedUart0Send(_baudRate baudRate);

/*!
	@brief Wstepny etap inicjalizacji systemu, jeszcze przed uruchomieniem funkcji main.
	@details W etapie tym dokonuje sie wylaczenia watchdobra, co ma na celu ochronę przed zapetleniem programu w przypadku
	gdy bedzie przerwanie od watchdoga.
*/
void preInit(void) __attribute__((naked)) __attribute__((section(".init3")));

/*!
	@brief Wczesne inicjalizowanie ustawien sprzetowych
	@details Dotyczy to ustawien podstawowych.
*/
void initHardwareEarly(void);

/*!
	@brief Pozne inicjalizowanie ustawien sprzetowych
	@details Dotyczy to ustawien wymaganych do wykonania na koncu procesu inicjalizacji.
*/
void initHardwareLate(void);

/*!
	@brief Wyłączenie sprzetu
*/
void hardwareTurnOff(void);

/*!
	@brief Obsluga peryferii mikrokontrolera wykonywana w kazdym cyklu petli glownej
	@details Resetowanie ukladu Watchdog Timera w kazdym cyklu petli glownej.
*/
void hardwareService(void);

/*!
	@brief Skok do początku aplikacji (do adresu 0x0000)
*/
void jumpToApplication(void);

#endif /* PROCESSOR_H_ */
