/*!
 *  @file protocolWago.h
 *	@brief Obsługa protokołu komunikacji z WAGO (Modbus)
 */ 
#ifndef PROTOCOLWAGO_H_
#define PROTOCOLWAGO_H_

#include <stdint.h>

#include "main.h"

#define MODBUS_EXCEPTION_NONE		0
#define MODBUS_EXCEPTION_FUNCTION	1
#define MODBUS_EXCEPTION_ADDRESS	2
#define MODBUS_EXCEPTION_QUANTITY	3
#define MODBUS_EXCEPTION_WRITE		4

//Adres urzadzenie (w protokole modbus) w przypadku gdy na dipswitchu ustawiono wartosc 0
#define MODBUS_ADDRESS_SERVICE		1

/*!
	@def MODBUS_FIRST_ADDRESS
    @brief Adres pierwszego rejestru, jaki jest dostepny po protokole modbus
*/
#define MODBUS_FIRST_ADDRESS  0xD

/*!
	@def MODBUS_VERIFICATION_DATA_ADDRESS
    @brief Adres rejestru pod ktory nalezy zapisac dane weryfikacyjne wgrywane oprogramowanie
*/
#define MODBUS_VERIFICATION_DATA_ADDRESS  0x75AA

/*! 
	@def MODBUS_USER_SPACE_SIZE
    @brief Wielko przestrzeni systemowej dostpnej przez modbus
*/
enum{
	//output:
	MODBUS_ACT_SOFT_STATE_ADDRESS	= 0x0D,		/** < status aktualizatora*/
	MODBUS_SYSTEM_BOOT_VER			= 0x0D,		/** < wersja bootloadera */
	MODBUS_SYSTEM_APP_VER			= 0x0E,		/** < wersja programu zwykego */
	MODBUS_SYSTEM_SPACE_SIZE,
};

/*!
	@brief Sprawdzenie czy otrzymana ramka moe by kompletna
	@details Funkcja ta sprawdza zawarto ramki pod ktem tego, czy otrzymano ju pen ramk.
	Wprowadzenie tej ramki wynika z faktu, e podstawowy sposb okrelania koca ramki (np. wyzerowania sumy CRC) moe
	by nieskuteczny na skutek wystpienia przypadkowej kombinacji danych.
	@return 0-w przypadku wykluczenia odebrania penej ramki; !0-w przypadku odebrania penej ramki
*/
uint8_t isFrameCompleteWago(void);

/*!
	@brief Analiza ramki zgodnie z protokołem WAGO (Modbus)
	@details Metoda analizuje otrzymaną ramkę i w razie potrzeby przygotowuje odpowiedź.
	@return Ilość bajtów jaka jest przygotowana do odesłania. W przypadku gdy nie potrzebna jest odpowiedź,
		zwracana jest wartość 0.
*/
uint16_t parseFrameWago(void);

void saveCrcToFlash(uint16_t crc);

#endif /* PROTOCOLWAGO_H_ */
