#include <stdint.h>
#include <avr/io.h>
#include "timers.h"
#include "processor.h"


/*!
	Flaga wykorzystywana do odmierzania stałych odstępów czasowych.
*/
volatile uint8_t timeMsFlag;

/*!
	@brief Tablica programowo zaimplementowanych timerów inkrementowanych na podstawie flagi timeMsFlag.
	@details Timery imkrementowane są co czas określony przez stałą @ref TIMEOUT_UNIT.
*/ 
uint8_t timersShort[TMR_SHORT_ALL];

/*!
	@brief Tablica programowo zaimplementowanych timerw inkrementowanych co 1 sekund.
*/ 
uint8_t timers1Sec[TMR_1SEC_ALL];


void initTimers( void )
{
	//wyzerowanie programowych timerow:
	for(int i=0; i<TMR_SHORT_ALL; i++)
		timersShort[i]=0;
}

void setTimerShort(_timersShort timerIndex, uint8_t value)
{
	timersShort[timerIndex] = value;
}

uint8_t getTimerShort(_timersShort timerIndex)
{
	return timersShort[timerIndex];
}

void setTimer1Sec(_timers1Sec timerIndex, uint8_t value)
{
	timers1Sec[timerIndex] = value;
}

uint8_t getTimer1Sec(_timers1Sec timerIndex)
{
	return timers1Sec[timerIndex];
}


void timersService( void )
{
	//timer 5ms:
	if(timeMsFlag)
	{
		timeMsFlag = 0;
		for(int i=0; i<TMR_SHORT_ALL; i++)
		{
			if(timersShort[i])
			{
				timersShort[i]--;
			}
		}
	}
	
	//timer 20ms:
	if(!getTimerShort(TMR_SHORT_TIME_20_MSEC))
	{
		setTimerShort(TMR_SHORT_TIME_20_MSEC, 20/TIMEOUT_UNIT);

	}
	
	
	
	//timer 100ms:
	if(!getTimerShort(TMR_SHORT_TIME_100_MSEC))
	{
		setTimerShort(TMR_SHORT_TIME_100_MSEC, TIME_100_MSEC_TIMEOUT);

	}

		//timer sekundowy:
	if(!getTimerShort(TMR_SHORT_TIME_1_SEC))
	{
		setTimerShort(TMR_SHORT_TIME_1_SEC, TIME_1_SEC_TIMEOUT);
		for(int i=0; i<TMR_1SEC_ALL; i++)
		{
			if(timers1Sec[i])
			{
				timers1Sec[i]--;
			}
		}
	}
}
