#include "dipswitch.h"

#include <avr/io.h>
#include "adc.h"
#include "lcdButton.h"
#include "main.h"



/*!
 *	@brief
 *		Procedura dokonuje przeskalowania napiecia zmierzonego na wejsciu (wartosc 10-bitowa)
 *		na wartosc 4-bitowa wyznaczona przez podzielnik napieciowy
 *	@param R16:R17
 *		Zmierzone napiecie
 *	@return R16
 *		Wartosc
 */
uint8_t dipswitchHalfValue(uint16_t advValue)
{
	uint8_t result;
	
	if(advValue < 28)
	result = 0;
	else if(advValue < 84)
	result = 1;
	else if(advValue < 134)
	result = 2;
	else if(advValue < 174)
	result = 3;
	else if(advValue < 210)
	result = 4;
	else if(advValue < 242)
	result = 5;
	else if(advValue < 276)
	result = 6;
	else if(advValue < 308)
	result = 7;
	else if(advValue < 335)
	result = 8;
	else if(advValue < 368)
	result = 9;
	else if(advValue < 391)
	result = 10;
	else if(advValue < 410)
	result = 11;
	else if(advValue < 434)
	result = 12;
	else if(advValue < 455)
	result = 13;
	else if(advValue < 471)
	result = 14;
	else
	result =15;
	
	return result;
}

/*!
 *	@brief
 *		Inicjalizacja modulu dipswitch
 *	@details
 *		Inicjalizacja modulu dipswitch polega na odczytaniu wartosci fizycznej ustawionej
 *		na dipswitchu i zapisanie jej.
 *	@return dipSwitchValue
 *		Rzeczywista wartosc jaka jest ustawiona na dipswitchu
 */
void dipSwitchInit(void)
{
	uint16_t rawData;
	uint8_t highByte;
	uint8_t lowByte;
	
	adcSetChannel(ADC_CHANNEL_0);
	rawData = adcConvert();
	lowByte = dipswitchHalfValue(rawData);
	adcSetChannel(ADC_CHANNEL_1);
	rawData = adcConvert();
	highByte = dipswitchHalfValue(rawData);
	highByte <<= 4;
	lcdButtonData.dipswitchValue = highByte | lowByte;
}
