﻿/*
 * ds.h
 *
 * Created: 2012-02-29 00:36:37
 *  Author: marek
 */ 


#ifndef DS_H_
#define DS_H_

//commands:
#define	DS_CMD_SEROM	0xf0	//SEARCH ROM
#define	DS_CMD_RDROM	0x33	//READ ROM
#define	DS_CMD_MAROM	0x55	//MATCH ROM
#define	DS_CMD_SPROM	0xcc	//SKIP ROM
#define	DS_CMD_ALARM	0xec	//ALARM SEARCH
//functions:
#define	DS_FNC_CONV		0x44	//CONVERT T
#define	DS_FNC_RDSCR	0xbe	//READ SCRATCHPAD
#define	DS_FNC_WRSCR	0x4e	//WRITE SCRATCHPAD
#define	DS_FNC_CPSCR	0x48	//COPY SCRATCHPAD
#define	DS_FNC_RECEE	0xb8	//RECALL E2
#define	DS_FNC_RDPWR	0xb4	//READ POWER SUPPLY

//DS family codes:
#define FAMILY_CODE_DS18S20		0x10
#define FAMILY_CODE_DS18B20		0x28

// operacje niskopoziomowe:
#define dsForceLow()	DS_DIR_REG  |= (1<<DS_LINE)
#define dsForceHigh()	DS_DIR_REG  &= ~(1<<DS_LINE)
#define dsInput()		((DS_IN_REG & (1<<DS_LINE)) != 0)

// ilosc dostępnych na raz czujników (max. 4):
#define DS_SENSOR_COUNT			4
// dlugosc (w bajtach) ROM CODE:
#define DS_ROM_CODE_LENGTH		8

/*!
	@enum _timers1Sec
	@brief Lista programowo zaimplementowanych timerów inkrementowanych co 1 sekundę
*/
typedef enum {
	DS_STATE_IDLE,			/*!< stan bezczynnosci */
	DS_STATE_CONV,			/*!< trwa konwersja temperatury */
	DS_STATE_READ_TEMP,		/*!< trwa odczyt z kolejnych czujników */
}_dsWorkState;

/*!
	@brief Ustawienie rejestru konfiguracyjnego podlaczonych czujnikow
	@details  Ustawienie dokładności pomiaru na 11 bitów x.00, x.25, x.50, x.75. Czas pomiaru: 375ms
*/
void dsPrepareToWork(void);

/*!
	@brief Funkcja kontrolująca główne zachowanie czujników ds
*/
void dsServiceWork(void);

/*!
	@brief Funkcja usuwa z pamięci EEPROM i RAM kody ROM wskazanych czujników.
	@details Wskazanie polega na tym że odpowiedni bit ustawiony jest na 1
*/
void dsDeleteRomCodes(uint16_t deleteMask);

/*!
	@brief Funkcja zamienia miejscami dwa kody ROM czujników.
	@details Jeśli wskazano mniej czujników - operacja jest pomijana. Jeśli wskazana więcej niż dwa czujnika - miejscami zamieniane są dwa pierwsze spośród wskazanych czujników
*/
void dsSwapRomCodes(uint16_t swapMask);

/*!
	@brief Find the 'first' devices on the 1-Wire bus
	@details From Maxim website.
	@return true : device found, ROM number in ROM_NO buffer; false : no device present
*/
int OWFirst();

/*!
	@brief Find the 'next' devices on the 1-Wire bus
	@details From Maxim website.
	@return true : device found, ROM number in ROM_NO buffer; false : device not found, end of search
*/
int OWNext();

/*!
	@brief Zapis/odczyt bitu
	@details Funkcja wykorzystywana podczas odczytywania adresów rom wykrytych czujników
	@param 0-zapis bitu 0; !0-zapis bitu 1/odczyt bitu
	@return odczytany bit
*/
uint8_t dsReadWriteBit(uint8_t data);

/*!
	@brief Sekwencja inicjalizująca komunikację z czujnikiem DS
	@return kod błędu: 0 - jest jakiś czujnik na linii, !0 - brak czujnika na linii;
*/
uint8_t dsStartSeq(void);

/*!
	@brief Zapis/odczyt bajtu poprzez interfejs 1-wire
	@param bajt do wysłania (w przypadku odczytu parametr musi mieć wartość 0xFF)
	@return wysyłany/odczytywany bajt
*/
uint8_t dsReadWriteByte(uint8_t data);

#endif /* DS_H_ */