﻿/*
 * eemem.c
 *
 * Created: 2012-08-03 21:59:35
 *  Author: marek
 */ 
#include <avr/eeprom.h>
#include <avr/io.h>

#include "eemem.h"
#include "protocolWago.h"
#include "main.h"
#include "ds.h"
#include "lcdButton.h"




void initEepromData(void)
{
	uint8_t eepromFlag = eeprom_read_byte((uint8_t*)EE_ADDR_STRUCT_MARK);
	if(eepromFlag != __DATA_COMP_VER__)
	{
		for(int i = MODBUS_SYSTEM_BEGIN; i< MODBUS_SIZE; i++)
		{
			writeModbus(i, 0);
		}
		writeModbus(MODBUS_SYSTEM_DARKER_TIME, 600*10);		//60s*10
		writeModbus(MODBUS_SYSTEM_BACKLIGHT_ON, 100);		//100%
		writeModbus(MODBUS_SYSTEM_BACKLIGHT_OFF, 0);		//0%
		writeModbus(MODBUS_SYSTEM_BUZZER_TIME, 2);
		writeModbus(MODBUS_SYSTEM_UART_SPEED, BAUDRATE_DEFAULT_UART0);
		writeModbus(MODBUS_SYSTEM_MODBUS_SOFT_ADDR, 1);
		eepromService(LCD_EEPROM_INIT_SAVE);
	}
	else
	{
		eeprom_read_block(lcdButtonData.modbusSpace, (uint8_t *)EE_ADDR_MODBUS_SPACE, EE_ADDR_MODBUS_SPACE_SIZE);
	}
}


void eepromService(_eepromCmd cmd)
{
	static uint8_t saveActiveFlag = false;
	uint8_t save = 0;
	
	if(cmd == LCD_EEPROM_INIT_SAVE)
	{
		eeprom_write_byte((uint8_t*)EE_ADDR_STRUCT_MARK, __DATA_COMP_VER__);
		save = 1;
	}
	else if(!saveActiveFlag && cmd == LCD_EEPROM_SAVE)
	{
		saveActiveFlag = true;
	}
	else if(saveActiveFlag && !getTimer100msec(TMR_100MSEC_SAVE_TO_EEPROM))
	{
		setTimer100msec(TMR_100MSEC_SAVE_TO_EEPROM, 100);		//archiwizacja danych po 10 sekundach od zmiany
		saveActiveFlag = false;
		save = 1;
	}
	
	if(save)
	{
		eeprom_update_block(lcdButtonData.modbusSpace, (uint8_t *)EE_ADDR_MODBUS_SPACE, EE_ADDR_MODBUS_SPACE_SIZE);
	}
}


void eepromReadDsRomCode(uint8_t * dataPnt)
{
	eeprom_read_block(dataPnt, (uint8_t *)EE_ADDR_DS_ROM_CODES, EE_ADDR_DS_ROM_CODES_SIZE);
}

void eepromWriteDsRomCode(uint8_t * dataPnt)
{
	eeprom_update_block(dataPnt, (uint8_t *)EE_ADDR_DS_ROM_CODES, EE_ADDR_DS_ROM_CODES_SIZE);
}

void eepromReadLightScene(uint8_t lightSceneIndex, uint16_t * dataPnt)
{
	if(lightSceneIndex < LIGHT_SCENE_COUNT)
	{
		eeprom_read_block((uint8_t *)dataPnt, (uint8_t *)(EE_ADDR_SCENE_LIGHTS_REG_SIZE + lightSceneIndex * (EE_ADDR_SCENE_LIGHTS_SINGLE_SIZE)), EE_ADDR_SCENE_LIGHTS_SINGLE_SIZE);
	}
}

void eepromWriteLightScene(uint8_t lightSceneIndex, uint16_t * dataPnt)
{
	if(lightSceneIndex < LIGHT_SCENE_COUNT)
	{
		eeprom_update_block((uint8_t *)dataPnt, (uint8_t *)(EE_ADDR_SCENE_LIGHTS_REG_SIZE + lightSceneIndex * (EE_ADDR_SCENE_LIGHTS_SINGLE_SIZE)), EE_ADDR_SCENE_LIGHTS_SINGLE_SIZE);
	}
}