﻿/*
 * eemem.h
 *
 * Created: 2012-08-03 21:59:55
 *  Author: marek
 */ 


#ifndef EEMEM_H_
#define EEMEM_H_

/************************************************************************/
/* Przestrzen eeprom:                                                       */
/************************************************************************/
//adresy poczatkowe blokow:
#define EE_ADDR_START			(uint16_t)0x0000
#define EE_ADDR_STRUCT_MARK		(EE_ADDR_START)
#define EE_ADDR_DS_ROM_CODES	((EE_ADDR_STRUCT_MARK) + (EE_ADDR_STRUCT_MARK_SIZE))
#define EE_ADDR_MODBUS_SPACE	((EE_ADDR_DS_ROM_CODES) + (EE_ADDR_DS_ROM_CODES_SIZE))
#define EE_ADDR_SCENE_LIGHTS	((EE_ADDR_MODBUS_SPACE) + (EE_ADDR_MODBUS_SPACE_SIZE))
#define EE_ADDR_END				((EE_ADDR_SCENE_LIGHTS) + (EE_ADDR_SCENE_LIGHTS_SIZE))
//rozmiary bloków:
#define EE_ADDR_STRUCT_MARK_SIZE			1
#define EE_ADDR_DS_ROM_CODES_SIZE			((DS_SENSOR_COUNT)*(DS_ROM_CODE_LENGTH))
#define EE_ADDR_MODBUS_SPACE_REG_SIZE		2
#define EE_ADDR_MODBUS_SPACE_SIZE			((MODBUS_SIZE)*(EE_ADDR_MODBUS_SPACE_REG_SIZE))
#define EE_ADDR_SCENE_LIGHTS_REG_SIZE		2
#define EE_ADDR_SCENE_LIGHTS_REG_COUNT		((MODBUS_SYSTEM_LIGHT_SCENE_REG_LAST)-(MODBUS_SYSTEM_LIGHT_SCENE_REG_FIRST)+1)
#define EE_ADDR_SCENE_LIGHTS_SINGLE_SIZE	((EE_ADDR_SCENE_LIGHTS_REG_COUNT)*(EE_ADDR_SCENE_LIGHTS_REG_SIZE))
#define EE_ADDR_SCENE_LIGHTS_SIZE			((LIGHT_SCENE_COUNT)*(EE_ADDR_SCENE_LIGHTS_SINGLE_SIZE))
/************************************************************************/

/*!
	@enum _eepromCmd
	@brief Zbiór poleceń związanych z kontrolą eepromu
*/
typedef enum{
	LCD_EEPROM_NORMAL_CMD,			/*! < normalny tryb pracy */
	LCD_EEPROM_SAVE,				/*! < dokonano zmiany w przestrzenii modbus, należy zapisać to do eepromu */
	LCD_EEPROM_INIT_SAVE,			/*! < inicjalizacja przestrzenii modbus, należy zapisać to do eepromu od razu*/
}_eepromCmd;

/*!
	@brief Inicjalizacja danych przechowywanych w eepromie
*/
void initEepromData(void);

/*!
	@brief Zapisywanie przestrzeni modbus do eepromu
*/
void eepromService(_eepromCmd cmd);

/*!
	@brief Odczytanie z pamięci EEPROM wartość ROM CODE wszystkich czujników
	@details Zapisany jest cały numer, łącznie z bajtem rodziny (28h-pierwszy bajt i sumą CRC (ostatni bajt)
	@param dataPnt Wskaźnik do bufora, w którym ma być zapisany odczytany numer
*/
void eepromReadDsRomCode(uint8_t * dataPnt);


/*!
	@brief Zapisanie do pamięci EEPROM wartość ROM CODE wszystkich czujników
	@details Zapisany jest cały numer, łącznie z bajtem rodziny (28h-pierwszy bajt i sumą CRC (ostatni bajt)
	@param dataPnt Wskaźnik do bufora, z którego mają być odczytane kody ROM czujników
*/
void eepromWriteDsRomCode(uint8_t * dataPnt);

/*!
	@brief Funkcja odczytuje z eepromu do pamięci RAM wskazaną scenę świetlną
	@param lightSceneIndex indeks sceny do wczytania
	@param dataPnt wskaźnik na pamięć RAM gdzie mają być zapisane dane
*/
void eepromReadLightScene(uint8_t lightSceneIndex, uint16_t * dataPnt);

/*!
	@brief Funkcja zapisuje do eepromu z pamięci RAM wskazaną scenę świetlną
	@param lightSceneIndex indeks sceny do zapisania
	@param dataPnt wskaźnik na pamięć RAM skąd mają być odczytane dane
*/
void eepromWriteLightScene(uint8_t lightSceneIndex, uint16_t * dataPnt);
#endif /* EEMEM_H_ */