﻿/*
 * led.c
 *
 * Created: 2012-03-02 00:01:28
 *  Author: marek
 */ 

#include <stdint.h>
#include <avr/io.h>
#include "led.h"
#include "processor.h"
#include "lcdButtonTimers.h"
#include "main.h"



/*!
	@enum _ledWorkState
	@brief Tryby pracy diody led
*/
typedef enum
{
	LED_WORK_NONE,			//brak dzialania diody
	LED_WORK_NORMAL,		//swiecenie na wzor bicia serca
	LED_WORK_NEW_DS,		//swiecenie przez dluzszy czas po wykryciu nowego czujnika ds
}_ledWorkState;

/**< pożadany tryb swiecenia diody */
_ledWorkState ledState;

/**< ostatni rzeczywisty tryb swiecenia diody */
_ledWorkState lastLedState = LED_WORK_NONE;

/*!
	@brief 
		Zakomunikowanie dioda o tym ze wykryto nowy czujnik DS (dioda swieci sie jednolicie przez 5s)
*/
void ledShowNewDs(void)
{
	ledState = LED_WORK_NEW_DS;
}

/*!
	@brief 
		Zakomunikowanie dioda o normalnej pracy urzadzenia (dioda mruga  w stylu bijacego serca)
*/
void ledShowNormalWork(void)
{
	ledState = LED_WORK_NORMAL;
}

void ledService(void)
{
	static uint8_t workSubstate = 0;
	
	if(ledState != lastLedState)
	{
		lastLedState = ledState;
		workSubstate = 0;
	}
	
	if(lastLedState == LED_WORK_NONE)
	{
		LED_OFF();
	}
	else if(lastLedState == LED_WORK_NEW_DS)
	{
		LED_ON();
		if(!getTimerShort(TMR_SHORT_LED))
		{
			if(workSubstate<5)
			{
				setTimerShort(TMR_SHORT_LED, 1000/TIMEOUT_UNIT);	//1sek
				workSubstate++;
			}
			else
			{
				ledState = LED_WORK_NORMAL;
			}
		}
		
	}else// if(lastLedState == LED_NEW_DS)
	{
		switch(workSubstate)
		{
			case 0:
				if(!getTimerShort(TMR_SHORT_LED))
				{
					//wlaczenie pierwszego swiecenia:
					setTimerShort(TMR_SHORT_LED, 75/TIMEOUT_UNIT);
					workSubstate = 1;
					LED_ON();
				}
				break;
			case 1:
				if(!getTimerShort(TMR_SHORT_LED))
				{
					//wylaczenie pierwszego swiecenia
					setTimerShort(TMR_SHORT_LED, 75/TIMEOUT_UNIT);
					workSubstate = 2;
					LED_OFF();
				}
				break;
			case 2:
				if(!getTimerShort(TMR_SHORT_LED))
				{
					//wlaczenie drugiego siecienia swiecenia:
					setTimerShort(TMR_SHORT_LED, 400/TIMEOUT_UNIT);
					workSubstate = 3;
					LED_ON();
				}
				break;
			case 3:
				if(!getTimerShort(TMR_SHORT_LED))
				{
					//wylaczenie drugiego swiecenia
					setTimerShort(TMR_SHORT_LED, 1000/TIMEOUT_UNIT);
					workSubstate = 4;
					LED_OFF();
				}
				break;
			case 4:
				if(!getTimerShort(TMR_SHORT_LED))
				{
					//wylaczenie drugiego swiecenia
					setTimerShort(TMR_SHORT_LED, 500/TIMEOUT_UNIT);
					workSubstate = 0;
					LED_OFF();
				}
				break;
		}
	}
}