﻿/*!
 *  @file main.h
 *	@brief Główna pętla programu
 */ 


#ifndef MAIN_H_
#define MAIN_H_



#include <avr/io.h>
#include "string.h"
#include "lcd.h"
#include "crc.h"
#include "lcdButtonTimers.h"
#include "uart.h"
#include "protocolLcd.h"
#include "lcdButton.h"

extern _lcdButtonData lcdButtonData;

#define MAKE_VERSION(MSB, LSB)		(MSB)<<8 | (LSB)

/*! 
	@def NULL
    @brief Wartość NULL
*/
#ifndef NULL
#define NULL 0
#endif

#ifndef false
#define false 0
#endif
#ifndef true
#define true  1
#endif

/*!
	@def __INFO_DATA_STRUCT_VER__
	@brief Wersja struktury pastylki informacyjnej zapisanej we flashu gdzie przechowywane sa dane identyfikacyjne programu
*/
#define __INFO_DATA_STRUCT_VER__	1
/*!
	@def __APP_VER_MAIN__
	@brief Wersja programu
*/
#define __APP_VER_MAIN__			1
/*!
	@def __APP_VER_REV__
	@brief Wersja rewizji programu
*/
#define __APP_VER_REV__				15
/*!
	@def __DATA_COMP_VER__
	@brief Wersja kompatybilnosci danych przechowywanych we flashu (zmiana tej wersji spowoduje wykasowanie poprzednich danych  z eepromu)
*/
#define __DATA_COMP_VER__			2

/*!
	@struct _deviceInfo
	@brief Struktura zawierajace metryke programu.
*/
typedef struct
{
	uint8_t label[5];
	uint8_t structVersion;
	uint16_t softVersion;
	uint16_t uartSpeedEeAdd;		/*!< adres w pamieci eeprom, gdzie zapisana jest predkosc z jaka odbywa sie komunikacja */
	uint16_t modbusAddEeAdd;		/*!< adres w pamieci eeprom, gdzie zapisany jest programowo ustawiany adres modbus urzadzenia */
}_deviceInfo;

/*!
	@enum _command
	@brief Zbiór komend jakie moga byc przekazywane pomiedzy programem zwykłym a bootloaderem
*/
typedef enum
{
		CMD_EMPTY				= 0xFFFF,		/*!< Komenda pusta (brak komendy) */
		CMD_MASK				= 0xFF00,		/*!< Maska bitowa komendy */
		DATA_MASK				= 0x00FF,		/*!< Maska bitowa danych */
		//polecenia od normalnego programu do bootloadera:
		CMD_STAY_IN_BOOT		= 0x5100,		/*!< Niech bootloader po sprawdzeniu spójności pamięci flash pozostanie w bootloaderze */
		CMD_UPDATE_CRC			= 0x5200,		/*!< Niech bootloader zaktualizuje sumę CRC z całej sekcji aplikacji i powróci do wykonywania normalnego programu */
		//polecenia od bootloadera do normalnego programu:
		CMD_APP_NORMAL_RUN		= 0x5400,
}_command;

/*!
	@brief Metoda sluzy do ustawiania nowego trybu pracy
	@param newWorkState Nowy tryb pracy
*/
void setWorkState(_workState newWorkState);

/*!
	@brief Pobranie aktualnego trybu pracy
	@return Aktualny tryb pracy
*/
_workState getWorkState(void);

#endif /* MAIN_H_ */
