﻿/*
 * pid.c
 *
 * Created: 2012-08-29 04:06:08
 *  Author: marek
 */ 
#include "pid.h"
#include "lcdButton.h" 
#include "lcdButtonTimers.h"

extern _lcdButtonData lcdButtonData;

void algorytm_pid(SPidData * pidData)
{
	int16_t Kp;								//wzmocnienie czesci proporcjonalnej
	int16_t Ti;								//czas zdwojenia
	int16_t Td;								//czas wyprzedzenia
	int16_t setpoint;						//temperatura zadana
	int16_t minimum;						//wartosc minimalna wyjscia
    int16_t maximum;						//wartosc maksymalna wyjscia
	int16_t measuredValue;					//temperatura aktualna
    int16_t output;
	float integralAccumulator;
	float derivativeAccumulator;
	
	float deviation = 0;					//uchyb
	float proportionalTerm = 0;				//czlon proporcjonalny
	float integralTerm = 0;					//czlon calkujacy
	float derivativeTerm = 0;				//czlon rozniczkujacy
	
	//inicjalizacja danych:
	
	//parametr Kp:
	if(pidData->config & PID_CONFIG_KP_FROM_MODBUS_MASK)
		Kp = (int16_t)readModbus(pidData->paramKp);
	else
		Kp = (int16_t)pidData->paramKp;
	//parametr Ti:
	if(pidData->config & PID_CONFIG_TI_FROM_MODBUS_MASK)
		Ti = (int16_t)readModbus(pidData->paramTi);
	else
		Ti = (int16_t)pidData->paramTi;
	//parametr Td:
	if(pidData->config & PID_CONFIG_TD_FROM_MODBUS_MASK)
		Td = (int16_t)readModbus(pidData->paramTd);
	else
		Td = (int16_t)pidData->paramTd;
	//wartosc zadana:
	if(pidData->config & PID_CONFIG_SET_POINT_FROM_MODBUS_MASK)
		setpoint = (int16_t)readModbus(pidData->setPoint);
	else
		setpoint = (int16_t)pidData->setPoint;
	minimum = pidData->min;
	maximum = pidData->max;
	measuredValue = (int16_t)readModbus(pidData->actualAddress);
	output = (int16_t)readModbus(pidData->outputAddress);
	integralAccumulator = pidData->integralAccumulator;
	derivativeAccumulator = pidData->derivativeAccumulator;
	
	//wplyw kierunku dochodzenia do temperatury zadanej:
	if(pidData->config & PID_CONFIG_DIRECTION_MASK)
		measuredValue = 2 * setpoint - measuredValue;
	
	//czlon proporcjonalny:
	deviation = setpoint - measuredValue;
	proportionalTerm = Kp * deviation;
	
	//czlon calkujacy:
	if (Ti != 0)
	{
		if (output > minimum && output < maximum)
			integralTerm = proportionalTerm / Ti + integralAccumulator;
		else
			integralTerm = integralAccumulator;
	}
	else
	{
		integralTerm = 0;
	}
	if (integralTerm > (maximum - Kp * 2))
		integralTerm = maximum - Kp * 2;
	else if (integralTerm < minimum)
		integralTerm = minimum;
	
	//czlon rozniczkujacy:
	if (Td != 0)
	{
		derivativeTerm = Td * (-measuredValue) / (1 + /*alpha*/10);
		derivativeTerm -= derivativeAccumulator;
	}
	else
	{
		derivativeTerm = 0;
		derivativeAccumulator = 0;
	}
	if (derivativeTerm > maximum)
		derivativeTerm = maximum;
	else if (derivativeTerm < -maximum)
		derivativeTerm = -maximum;
	
	// wpisanie watości do akumulatorów
	pidData->integralAccumulator = integralTerm;
	pidData->derivativeAccumulator = derivativeTerm / (1 + /*alpha*/10) + derivativeAccumulator;
	
	// wyliczenie procentowej wartości wyjścia algorytmu
	output = proportionalTerm + integralTerm + derivativeTerm;
	if (output < minimum)
		output = minimum;
	if (output > maximum)
		output = maximum;

	writeModbus(pidData->outputAddress, output);
}

void pidClear(SPidData * pidData)
{
	pidData->derivativeAccumulator = 0;
	pidData->integralAccumulator = 0;
}

void pidService(void)
{
	static uint8_t lastPidActive[PID_MAX_COUNT];	
	uint8_t pidActive;
	uint16_t activatorValue;
	uint16_t activatorMask;
	if(!getTimerShort(TMR_SHORT_PID))
	{
		for(int i=0; i < lcdButtonData.pidCount && i < PID_MAX_COUNT; i++)
		{
			pidActive = 0;
			if(lcdButtonData.pidData[i].config & PID_CONFIG_ALLWAYS_ON_MASK)
			{
				pidActive = 1;
			}				
			else
			{
				activatorValue = readModbus(lcdButtonData.pidData[i].activatorAddress);
				activatorMask = (1 << lcdButtonData.pidData[i].activatorBitNumber);
				activatorValue &= activatorMask;
				if(((lcdButtonData.pidData[i].config & PID_CONFIG_ACTIV_BIT_VALUE_MASK) && activatorValue) ||
					(!(lcdButtonData.pidData[i].config & PID_CONFIG_ACTIV_BIT_VALUE_MASK) && !activatorValue))
				{
					pidActive = 1;
				}
			}
			
			if(lastPidActive[i] == 0 && pidActive != 0)
			{
				//jesli algorytm PID zostal wlasnie wlaczeny to nalezy go wyzerowac:
				pidClear(&lcdButtonData.pidData[i]);
			}
			lastPidActive[i] = pidActive;
			if(pidActive)
			{				
				algorytm_pid(&lcdButtonData.pidData[i]);
			}
		}
		setTimerShort(TMR_SHORT_PID, TIME_1_SEC_TIMEOUT);
	}		
}
