﻿/*
 * pid.h
 *
 * Created: 2012-08-29 04:06:19
 *  Author: marek
 */ 


#ifndef PID_H_
#define PID_H_

#include <avr/io.h>


/*!
	Maksymalna ilosc dostepnych obiektow PID
*/
#define PID_MAX_COUNT						4

/*!
	1 - Wartosc parametru Kp dostepna jest pod wskazanym adresem modbus
	0 - Kp podana jako stala wartosc
*/
#define PID_CONFIG_KP_FROM_MODBUS_MASK		(1<<0)
/*!
	1 - Wartosc parametru Ti dostepna jest pod wskazanym adresem modbus
	0 - Ti podana jako stala wartosc
*/
#define PID_CONFIG_TI_FROM_MODBUS_MASK		(1<<1)
/*!
	1 - Wartosc parametru Td dostepna jest pod wskazanym adresem modbus
	0 - Td podana jako stala wartosc
*/
#define PID_CONFIG_TD_FROM_MODBUS_MASK		(1<<2)
/*!
	1 - Wartosc zadana dostepna jest pod wskazanym adresem modbus
	0 - podana jako stala wartosc
*/
#define PID_CONFIG_SET_POINT_FROM_MODBUS_MASK	(1<<3)
/*!
	1 - Algorytm PID jest caly czas wlaczony 
	0 - Algorytm PID wlaczony na podstawie wartosci bitu aktywacyjnego we wskazanym rejestrze
*/
#define PID_CONFIG_ALLWAYS_ON_MASK			(1<<4)
/*!
	Wartosc bitu powodujaca wlaczenie algorytmu PID
*/
#define PID_CONFIG_ACTIV_BIT_VALUE_MASK		(1<<5)
/*!
	1 - Sterowanie dochodzeniem temperatury do zadanej od gory - chlodzenie;
	0 - Sterowanie dochodzeniem temperatury do zadanej od dołu - grzanie;
*/
#define PID_CONFIG_DIRECTION_MASK			(1<<6)

typedef struct
{
	uint8_t config;					/*!< konfiguracja */
	uint8_t actualAddress;			/*!< adres modbus rejestru wejsciowego dla PIDu */
	uint8_t outputAddress;			/*!< adres modbus gdzie umieszczany jest wynik dzialania PIDu */
	uint8_t min;					/*!< dolny zakres wyjsciowy algorytmu PID */
	uint8_t max;					/*!< gorny zakres wyjsciowy algorytmu PID */
	uint8_t activatorAddress;		/*!< adres aktywatora wlaczajacego kontroler PID */
	uint8_t activatorBitNumber;		/*!< numer/indeks bitu aktywatora wlaczajacego kontroler PID */
	uint16_t paramKp;				/*!< wartosc parametru Kp lub adres modbus pod ktorym ten parametr jest dostepny - zalezne od konfiguracji */
	uint16_t paramTi;				/*!< wartosc parametru Ti lub adres modbus pod ktorym ten parametr jest dostepny - zalezne od konfiguracji */
	uint16_t paramTd;				/*!< wartosc parametru Td lub adres modbus pod ktorym ten parametr jest dostepny - zalezne od konfiguracji */
	uint16_t setPoint;				/*!< wartosc temperatury zadanej lub adres modbus pod ktorym jest dostepna - zalezne od konfiguracji */
	float integralAccumulator;
	float derivativeAccumulator;
}SPidData;

void pidService(void);

#endif /* PID_H_ */